let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});
$$.objects = require('common/objects');

let idx = require('../js/idx-utils');
let archive = require('../js/archive');
let metadb = require('common/metadb');
let transaction = require('common/transaction');

let PACKAGE = '/agorum/roi/customers/isg.xpert.archive';
let WORKSPACE = '/agorum/roi/workspace/isg.xpert.archive';
let FILES = '/agorum/roi/Files/Medizinischer Dienst Bremen';

//let SAMPLE_FILTER = '10829010';
//let SAMPLE_ID = 'E057501230';

let dataDebug = $$.objects.find(PACKAGE + '/debug/data');
let dataImport = $$.objects.find(FILES + '/Import');
let dataBuffer = $$.objects.find(WORKSPACE + '/import_buffer');
let dataErrors = $$.objects.find(WORKSPACE + '/import_errors');
let dataIgnore = $$.objects.find(WORKSPACE + '/import_ignore');
let recArchive = $$.objects.find(FILES + '/Archiv/Versicherte');
let pdfTemplate = $$.objects.find(PACKAGE + '/debug/template.pdf');

// NO DOCUMENTS FOLDER IN ARCHIVE
let docArchive = $$.objects.tryFind(FILES + '/Archiv/Dokumente');

let RECORD_COUNTER = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/counter/records';
let DOCUMENT_COUNTER = 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/counter/documents';

let targets = {
  buffer: dataBuffer,
  import: dataImport,
};

// clear complet archive and reset counter
const clearArchive = () => {
  metadb.write(RECORD_COUNTER, null);
  metadb.write(DOCUMENT_COUNTER, null);
  // NO DOCUMENTS FOLDER IN ARCHIVE
  if (docArchive) {
    docArchive.items().forEach(item => {
      item.delete();
    });
  }
  recArchive.items().forEach(item => {
    item.delete();
  });
  dataBuffer.items().forEach(item => {
    item.delete();
  });
  dataImport.items().forEach(item => {
    item.delete();
  });
  dataErrors.items().forEach(item => {
    item.delete();
  });
  dataIgnore.items().forEach(item => {
    item.delete();
  });
};

// copy debug data to import buffer or active folder
const copyData = (_target, parms) => {
  let target = targets[_target];
  let limit = parms && parms.limit ? parms.limit : 1000;
  let baseQuery = 'inpath:{0} nameextension:idx'.format(dataDebug.ID);
  let query = parms && parms.filter ? baseQuery + ' ' + parms.filter : baseQuery;
  $$.objects
    .query(query)
    .limit(limit)
    .find()
    .forEach(item => {
      $$.debug('copyData - path', item.name, idx.splitPath(item.name));
      let base = idx.splitPath(item.name).base;
      $$.debug('copy [{0}] -> [{1}]'.format(base, target.name));
      $$.objects.copy(item, target);
      $$.objects.copy(pdfTemplate, target, base + '.pdf');
      $$.objects.create('file', {
        name: base + '.pdf.ok',
        target: target,
      });
    });
};

// process debug data directly from import_buffer without active folder
const processData = _limit => {
  let limit = _limit ? _limit : 1000;
  $$.objects
    .query('inpath:{0} nameextension:idx'.format(dataBuffer.ID))
    .limit(limit)
    .find()
    .forEach(item => {
      $$.debug('processData - item:', item);
      transaction(() => {
        archive.processDocument(item);
      });
    });
};

module.exports = {
  clearArchive: clearArchive,
  copyData: copyData,
  processData: processData,
  countData: (parms) => {
    let baseQuery = 'inpath:{0} nameextension:idx'.format(dataDebug.ID);
    let query = parms && parms.filter ? baseQuery + ' ' + parms.filter : baseQuery;
    return parms && parms.limit ? parms.limit : $$.objects.query(query).search().total;
  },
  countDocs: () => {
    let query = 'inpath:{0} nameextension:pdf'.format(docArchive.ID);
    return $$.objects.query(query).search().total;
  },
  sampleUrl: server => {
    // http://acdev-xpert.pvm.local/roiwebui/aguila_module/?type=isg.xpert.archive.acicArchiveView&external=true&id=E057501230
    return server + '/roiwebui/aguila_module/?type=isg.xpert.archive.acicArchiveView&external=true&id=E057501230';
  },
};
